require('dotenv').config()
const express = require('express');
const fs = require('fs');
const path = require('path');
const cookieParser = require('cookie-parser');
const logger = require('morgan');
const PORT = process.env.PORT || 5000;

//const indexRouter = require('./routes/index');
const usersRouter = require('./routes/users');
const bankRouter = require('./routes/bank');
const authRouter = require('./routes/auth');
const karyawanRouter = require('./routes/karyawan');
const karyawanfmRouter = require('./routes/karyawanfm');
const salaryRouter = require('./routes/salary');
const salaryincRouter = require('./routes/salaryinc');
const jenistrRouter = require('./routes/jenistr');
const jenisdanaRouter = require('./routes/jenisdana');
const jenislemburRouter = require('./routes/jenislembur');
const serverRouter = require('./routes/server');
const productRouter = require('./routes/product');
const trlemburRouter = require('./routes/trlembur');
const pinjamRouter = require('./routes/pinjam');
const prepinjamRouter = require('./routes/prepinjam');
const projectRouter = require('./routes/project');
const ajudanaRouter = require('./routes/ajudana');
const truangRouter = require('./routes/truang');
const app = express();

process.env.TZ ="Asia/Jakarta"

//app.use(logger('dev'));
// Setup morgan untuk mencatat log
const logFilePath = path.join(__dirname, 'logs/access.log');
const accessLogStream = fs.createWriteStream(logFilePath, { flags: 'a' });

// Konfigurasi morgan untuk format log
app.use(logger('combined', { stream: accessLogStream }));

app.use(express.json());
app.use(express.urlencoded({ extended: false }));
app.use(cookieParser());
app.use(express.static(path.join(__dirname, 'public')));

app.use('/users', usersRouter);
app.use('/bank', bankRouter);
app.use('/auth', authRouter);
app.use('/karyawan', karyawanRouter);
app.use('/karyawanfm', karyawanfmRouter);
app.use('/salary', salaryRouter);
app.use('/salaryinc', salaryincRouter);
app.use('/jenistr', jenistrRouter);
app.use('/jenisdana', jenisdanaRouter);
app.use('/jenislembur', jenislemburRouter);
app.use('/server', serverRouter);
app.use('/product', productRouter);
app.use('/trlembur', trlemburRouter);
app.use('/pinjam', pinjamRouter);
app.use('/prepinjam', prepinjamRouter);
app.use('/project', projectRouter);
app.use('/ajudana', ajudanaRouter);
app.use('/truang', truangRouter);

app.use((err, req, res, next) => {
    console.log(err.message)
    res.json({
        message: err.message
    })
})


app.listen(PORT, () => {
    console.log(`Jalan euy di port ${PORT} `, Date())
})
