//const { ValidationError } = require('sequelize');
const {
    Karyawan
} = require("../models");


const postcreate = async (req, res) => {
    const {
        body
    } = req;
    const createdby = req.user.data.username;
    const cekNIP = await Karyawan.findOne({
        where: {
            nip: body.nip,
        },
    });

    if (cekNIP) {
        return res.status(400).json({
            message: "NIP sudah digunakan",
        });
    }else{
        try {
            const karyawan = await Karyawan.create({
                nip: body.nip,
                nmlengkap: body.nmlengkap,
                jabatan: body.jabatan,
                user_id: body.user_id,
                nik: body.nik,
                tmptlahir: body.tmptlahir,
                tgllahir: body.tgllahir,
                agama: body.agama,
                nohp: body.nohp,
                pendakhir: body.pendakhir,
                ecnama: body.ecnama,
                echp: body.echp,
                echub: body.echub,
                statusnikah: body.statusnikah,
                jmlanak: body.jmlanak,
                statusaktif: body.statusaktif,
                tglmasuk: body.tglmasuk,
                tglkeluar: body.tglkeluar,
                createdBy: createdby
            });
    
            return res.status(201).json({
                message: 'Created'
                // data: {
                //     karyawan
                // }
            });
        } catch (error) {
            if (error.name === 'SequelizeValidationError') {
                const validationErrors = error.errors.map(err => ({
                  field: err.path,
                  message: err.message
                }));
                res.status(400).json({ "Validation Error": validationErrors });
              } else {
                res.status(500).json({ error: 'Internal Server Error' });
              }       
        }
    }

    
}
// Get All Data Bank
const getall = async (req, res) => {
    try {
        const karyawans = await Karyawan.findAll({
            attributes: { exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt'] }
        });
        if(karyawans.length != 0){ 
            return res.json(karyawans);
        } else { 
            return res.status(404).json({
                message: "Data tidak ditemukan"
            });
        }

        //return res.json(karyawans);
    } catch (error) {
        res.status(500).json({error: 'Internal Server Error'})
    }
}
const getid = async (req, res) => {
    const {
        nip
    } = req.params;

    try {
        const karyawan = await Karyawan.findByPk(nip, {
            attributes: { exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt'] }
        });
        if (!karyawan)
            return res.status(404).json({
                message: "Data tidak ditemukan"
            });

        return res.json(karyawan);
    } catch (error) {
        res.status(500).json({ error: 'Internal Server Error' });
    }
}
const putid = async (req, res) => {
    const {
        nip
    } = req.params;
    const updatedBy = req.user.data.username;
    let updateData = { ...req.body, updatedBy };
    try {
        const karyawan = await Karyawan.findByPk(nip, {});
        if (!karyawan)
            return res.status(404).json({
                message: "Data tidak ditemukan"
            });

        await karyawan.update(updateData);
        return res.json({
            message: "Updated",
        });
    } catch (error) {
        if (error.name === 'SequelizeValidationError') {
            const validationErrors = error.errors.map(err => ({
              field: err.path,
              message: err.message
            }));
            res.status(400).json({ "Validation Error": validationErrors });
          } else {
            console.log(error.message);
            res.status(500).json({ error: 'Internal Server Error' });
          }
    }
}
const delid = async (req, res) => {
    const {
        nip
    } = req.params;

    try {
        const karyawan = await Karyawan.findByPk(nip, {});
        if (!karyawan)
            return res.status(404).json({
                message: "Data tidak ditemukan",
            });

        await karyawan.destroy();
        return res.json({
            message: "Deleted",
        });
    } catch (error) {
        console.log(error.message);
        res.status(500).json({ error: 'Internal Server Error' });
    }
}
module.exports = {
    getall,
    postcreate,
    getid,
    putid,
    delid
}