const {
    Prepinjam,
    Pinjam,
    Karyawan,
    Sequelize
} = require("../models");
const Op = Sequelize.Op;

const postcreate = async (req, res) => {
    const {
        body
    } = req;
    const createdBy = req.user.data.username;
    let createData = {
        ...req.body,
        createdBy
    };

    if (!body.nip) {
        return res.status(400).json({
            "Validation Error": {
                field: "nip",
                message: "Tidak Boleh Null/Kosong"
            }
        });
    }

    const cekNIP = await Karyawan.findOne({
        where: {
            nip: body.nip,
        },
    });

    if (!cekNIP) {
        return res.status(404).json({
            message: "Data Karyawan tidak ditemukan"
        });
    }

    const cekpinjam = await Prepinjam.findOne({
        attributes: {
            exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt']
        },
        where: {
            nip: body.nip,
        },
    });

    if (cekpinjam) {
        return res.status(400).json({
            message: "Premi sudah ada",
            data: cekpinjam
        });
    } else {

        try {
            await Prepinjam.create(createData);

            return res.status(201).json({
                message: 'Created'
            });
        } catch (error) {
            if (error.name === 'SequelizeValidationError') {
                const validationErrors = error.errors.map(err => ({
                    field: err.path,
                    message: err.message
                }));
                res.status(400).json({
                    "Validation Error": validationErrors
                });
            } else {
                res.status(500).json({
                    error: 'Internal Server Error'
                });
                console.log(error)
            }
        }
    }

}
const getsalary = async (req, res) => {

    try {
        Pinjam.belongsTo(Prepinjam, { foreignKey: 'nip', targetKey: 'nip' });

        const Results = await Pinjam.findAll({
            attributes: [
                'nip',
                [Sequelize.fn('SUM', Sequelize.col('debet')), 'total_debet'],
                [Sequelize.fn('SUM', Sequelize.col('kredit')), 'total_kredit']
            ],
            group: ['nip'],
            include: [{
                model: Prepinjam,
                attributes: ['premi']
            }],
            raw: true
        });
        const tagihan = Results.map(Results => {
            const totalDebet = parseFloat(Results.total_debet);
            const totalKredit = parseFloat(Results.total_kredit);
            const premi = parseFloat(Results['Prepinjam.premi']);
            const saldo = totalDebet - totalKredit;
            const nilaiTagihan = saldo > premi ? premi : saldo;

            return {
                nip: Results.nip,
                angsuran: nilaiTagihan
            };
        });

        res.status(200).json(tagihan);        

    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error',
            message: error.message
        })
    }

}
const getall = async (req, res) => {
    const {
        body
    } = req;

    let nnip = '%%'

    try {
        const Prepinjams = await Prepinjam.findAll({
            attributes: {
                exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt']
            },
            where: {
                nip: {
                    [Op.like]: nnip,
                }
            }
        });
        if (Prepinjams.length != 0) {
            return res.json(Prepinjams);
        } else {
            res.status(404).json({
                message: "Data tidak ditemukan",
            })
        }

    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        })
    }

}
const getid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const prepinjam = await Prepinjam.findByPk(id, {
            attributes: {
                exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt']
            }
        });
        if (!prepinjam)
            return res.status(404).json({
                message: "Data tidak ditemukan",
            });

        return res.json(prepinjam);
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        })
    }
}
const putid = async (req, res) => {
    const {
        id
    } = req.params;
    const updatedBy = req.user.data.username;
    let updateData = {
        ...req.body,
        updatedBy
    };
    try {
        const prepinjam = await Prepinjam.findByPk(id, {});
        if (!pinjam)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        await prepinjam.update(updateData);
        return res.status(201).json({
            message: 'Updated'
        });
    } catch (error) {
        if (error.name === 'SequelizeValidationError') {
            const validationErrors = error.errors.map(err => ({
                field: err.path,
                message: err.message
            }));
            res.status(400).json({
                "Validation Error": validationErrors
            });
        } else {
            res.status(500).json({
                error: 'Internal Server Error'
            });
        }
    }
}
const delid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const prepinjam = await Prepinjam.findByPk(id, {});
        if (!prepinjam)
            return res.status(404).json({
                message: "Data tidak ditemukan",
            });

        await prepinjam.destroy();
        return res.json({
            message: "Deleted",
        });
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        })
    }
}
module.exports = {
    getsalary,
    getall,
    postcreate,
    getid,
    putid,
    delid
}