const {
    Product
} = require("../models");

const {
    callWhmcsApi
} = require('../handlers/getwhmcs');

const {
    groupproduts
} = require('../config/custom.js');

const getwhmcs = async (req, res) => {
    try {
        const result = await callWhmcsApi('GetProducts');
        //console.log('Data to be sent:', JSON.stringify(result, null, 2));
        const products = result.products.product;

        for (const product of products) {
            const Typeproduct = await GetType(product.type);
            const NamaGroup = await GetGroup(product.gid);
            //console.log(JSON.stringify(`Product ID: ${product.pid}, Nama Group: ${NamaGroup}, Nama: ${product.name},Type: ${Typeproduct}`));

            const cekPID = await Product.findOne({
                where: {
                    whmcs_pid: product.pid,
                },
            });
            if (cekPID) {
                await cekPID.update({
                    nmproduk: product.name,
                    typeproduk: Typeproduct,
                    groupproduk: NamaGroup,
                    updatedBy: "System"
                });
            } else {
                try {
                    await Product.create({
                        nmproduk: product.name,
                        typeproduk: Typeproduct,
                        groupproduk: NamaGroup,
                        whmcs_pid: product.pid,
                        createdBy: "System"
                    });
                    console.log({
                        message: 'Created',
                        data: Product
                    })
                    // return res.status(201).json({
                    //     message: 'Created'
                    // });
                } catch (error) {
                    if (error.name === 'SequelizeValidationError') {
                        const validationErrors = error.errors.map(err => ({
                            field: err.path,
                            message: err.message
                        }));
                        res.status(400).json({
                            "Validation Error": validationErrors
                        });
                    } else {
                        res.status(500).json({
                            error: 'Internal Product Error'
                        });
                    }
                }
            }
        }
        return res.status(200).json({
            message: 'Synced'
        });
    } catch (error) {
        console.log('Error fetching client data:', error.response ? error.response.data : error.message);
    }
}
async function GetType(TypePr) {
    //console.log(TypePr)
    let Typeproduct
    switch (TypePr) {
        case "hostingaccount":
            Typeproduct = "Shared Hosting";
            break;
        case "reselleraccount":
            Typeproduct = "Reseller Hosting";
            break;
        case "server":
            Typeproduct = "VPS/Server";
            break;
        case "other":
            Typeproduct = "Product/Service";
            break;
    }
    //console.log(Typeproduct)
    return Typeproduct;
}
async function GetGroup(id) {
    const Group = groupproduts.find(g => g.id === id);
    //console.log(nama);
    return Group.nama
}
const postcreate = async (req, res) => {
    const {
        body
    } = req;
    const createdBy = req.user.data.username;
    let createData = {
        ...req.body,
        createdBy
    };

    try {
        await Product.create(createData);

        return res.status(201).json({
            message: 'Created'
        });
    } catch (error) {
        if (error.name === 'SequelizeValidationError') {
            const validationErrors = error.errors.map(err => ({
                field: err.path,
                message: err.message
            }));
            res.status(400).json({
                "Validation Error": validationErrors
            });
        } else {
            res.status(500).json({
                error: 'Internal Product Error'
            });
        }
    }

}
const getall = async (req, res) => {
    try {
        const Products = await Product.findAll({
            attributes: {
                exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt']
            }
        });
        if (Products.length != 0) {
            return res.json(Products);
        } else {
            return res.status(404).json({
                message: "Data tidak ditemukan"
            });
        }
    } catch (error) {
        res.status(500).json({
            error: 'Internal Product Error'
        });
    }
}
const getid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const Products = await Product.findByPk(id, {
            attributes: {
                exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt']
            }
        });
        if (!Products)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        return res.json(Products);
    } catch (error) {
        res.status(500).json({
            error: 'Internal Product Error'
        });
    }
}
const putid = async (req, res) => {
    const {
        id
    } = req.params;
    const updatedBy = req.user.data.username;
    let updateData = {
        ...req.body,
        updatedBy
    };
    try {
        const Products = await Product.findByPk(id, {});
        if (!Products)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        await Products.update(updateData);
        return res.status(201).json({
            message: 'Updated'
        });
    } catch (error) {
        if (error.name === 'SequelizeValidationError') {
            const validationErrors = error.errors.map(err => ({
                field: err.path,
                message: err.message
            }));
            res.status(400).json({
                "Validation Error": validationErrors
            });
        } else {
            res.status(500).json({
                error: 'Internal Product Error'
            });
        }
    }
}
const delid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const Products = await Product.findByPk(id, {});
        if (!Products)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        await Products.destroy();
        return res.json({
            message: "Deleted",
        });
    } catch (error) {
        res.status(500).json({
            error: 'Internal Product Error'
        });
    }
}
module.exports = {
    getwhmcs,
    getall,
    postcreate,
    getid,
    putid,
    delid
}