const {
    Salaryinc, Sequelize
} = require("../models");
const {
    Karyawan
} = require("../models");
const Op = Sequelize.Op;
const { updateSalary } = require('../handlers/uptsalari');
const postcreate = async (req, res) => {
    const {
        body
    } = req;
    const updatedBy = req.user.data.username;
    const createdBy = req.user.data.username;
    let updateData = {
        ...req.body,
        updatedBy
    };
    let createData = {
        ...req.body,
        createdBy
    };
    if (!body.thnsal |!body.blnsal | !body.nip){
        return res.status(400).json({
            "Validation Error": {
                field:"thnsal/blnsal/nip",
                message:"Tidak Boleh Null/Kosong"}
        });
    }

    const cekNIP = await Karyawan.findOne({
        where: {
            nip: body.nip,
        },
    });

    if (!cekNIP) {
        return res.status(404).json({
            message: "Data Karyawan tidak ditemukan"
        });
    }

    const cekBulansal = await Salaryinc.findOne({
        where: {
            thnsal: body.thnsal,
            blnsal: body.blnsal,
            nip: body.nip
        },
    });

    if (cekBulansal) {
        try {
            await cekBulansal.update(updateData);
            await updateSalary(body.thnsal,body.blnsal,body.nip,updatedBy)
            
            return res.status(201).json({
                message: 'Updated'
            });
        } catch (error) {
            if (error.name === 'SequelizeValidationError') {
                const validationErrors = error.errors.map(err => ({
                    field: err.path,
                    message: err.message
                }));
                res.status(400).json({
                    "Validation Error": validationErrors
                });
            } else {
                res.status(500).json({
                    error: 'Internal Server Error'
                });
                console.log(error)
            }
        }

    } else {
        try {
            await Salaryinc.create(createData);
            await updateSalary(body.thnsal,body.blnsal,body.nip,updatedBy)

            return res.status(201).json({
                message: 'Created'
            });
        } catch (error) {
            if (error.name === 'SequelizeValidationError') {
                const validationErrors = error.errors.map(err => ({
                    field: err.path,
                    message: err.message
                }));
                res.status(400).json({
                    "Validation Error": validationErrors
                });
            } else {
                res.status(500).json({
                    error: 'Internal Server Error'
                });
                console.log(error)
            }
        }
    }

    //create atau update salary
    
    
}
const getall = async (req, res) => {
    const {
        body
    } = req;
    if (!body.thnsal)
        return res.status(400).json({
            message: "Tentukan tahun salary",
        });

    try {
        const thsalary = await Salaryinc.findAll({
            attributes: {
                exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt']
            },
            order: [
                ['nip', 'ASC'],
                ['blnsal', 'ASC']
            ],
            where: {
                thnsal: body.thnsal
            }
        });
        const grupnip = thsalary.reduce((result, item) => {
            const {
                nip
            } = item;
            if (!result[nip]) {
                result[nip] = [];
            }
            result[nip].push(item);
            return result;
        }, {});

        const groupedArray = Object.keys(grupnip).map(nip => ({
            nip,
            items: grupnip[nip]
        }));

        res.status(200).json(groupedArray);

    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        })
    }
}
const getid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const salary = await Salaryinc.findByPk(id, {});
        if (!salary)
            return res.status(404).json({
                message: "Data tidak ditemukan",
            });

        return res.json(salary);
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        })
    }
}
const putid = async (req, res) => {
    const {
        id
    } = req.params;
    const updatedBy = req.user.data.username;
    let updateData = { ...req.body, updatedBy };
    try {
        const salary = await Salaryinc.findByPk(id, {});
        if (!salary)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        await salary.update(updateData);
        await updateSalary(body.thnsal,body.blnsal,body.nip,updatedBy)

        return res.status(201).json({
            message: 'Updated'
        });

    } catch (error) {
        if (error.name === 'SequelizeValidationError') {
            const validationErrors = error.errors.map(err => ({
                field: err.path,
                message: err.message
            }));
            res.status(400).json({
                "Validation Error": validationErrors
            });
        } else {
            res.status(500).json({
                error: 'Internal Server Error'
            });
            console.log(error)
        }
    }
    
    
}
const delid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const salary = await Salaryinc.findByPk(id, {});
        if (!salary)
            return res.status(404).json({
                message: "Data tidak ditemukan",
            });

        await salary.destroy();
        return res.json({
            message: "Deleted",
        });
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        })
    }
}
module.exports = {
    getall,
    postcreate,
    getid,
    putid,
    delid
}