const {
    Server
} = require("../models");

const postcreate = async (req, res) => {
    const {
        body
    } = req;
    const createdBy = req.user.data.username;
    let createData = {
        ...req.body,
        createdBy
    };

    try {
        const cekServer = await Server.findOne({
            where: {
                hostname: body.hostname,
            },
        });

        if (cekServer) {
            return res.status(400).json({
                message: "Nama atau Hostname server sudah ada",
            });
        }else {
            try {
                await Server.create(createData);
        
                return res.status(201).json({
                    message: 'Created'
                });
            } catch (error) {
                if (error.name === 'SequelizeValidationError') {
                    const validationErrors = error.errors.map(err => ({
                        field: err.path,
                        message: err.message
                    }));
                    res.status(400).json({
                        "Validation Error": validationErrors
                    });
                } else {
                    res.status(500).json({
                        error: 'Internal Server Error'
                    });
                }
            }
        }

    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error',
            message: error.message
        });
    }
    
}
const getall = async (req, res) => {
    try {
        const Servers = await Server.findAll({
            attributes: {
                exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt']
            }
        });
        if (Servers.length != 0) {
            return res.json(Servers);
        } else {
            return res.status(404).json({
                message: "Data tidak ditemukan"
            });
        }
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        });
    }
}
const getid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const Servers = await Server.findByPk(id, {
            attributes: {
                exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt']
            }
        });
        if (!Servers)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        return res.json(Servers);
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        });
    }
}
const putid = async (req, res) => {
    const {
        id
    } = req.params;
    const updatedBy = req.user.data.username;
    let updateData = {
        ...req.body,
        updatedBy
    };
    try {
        const Servers = await Server.findByPk(id, {});
        if (!Servers)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        await Servers.update(updateData);
        return res.status(201).json({
            message: 'Updated'
        });
    } catch (error) {
        if (error.name === 'SequelizeValidationError') {
            const validationErrors = error.errors.map(err => ({
                field: err.path,
                message: err.message
            }));
            res.status(400).json({
                "Validation Error": validationErrors
            });
        } else {
            res.status(500).json({
                error: 'Internal Server Error'
            });
        }
    }
}
const delid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const Servers = await Server.findByPk(id, {});
        if (!Servers)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        await Servers.destroy();
        return res.json({
            message: "Deleted",
        });
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        });
    }
}
module.exports = {
    getall,
    postcreate,
    getid,
    putid,
    delid
}