const {
    Truang, Product
} = require("../models");

const moment = require("moment");
const {
    callWhmcsApi
} = require('../handlers/getwhmcs');

const {
    groupproduts
} = require('../config/custom.js');

const postwhmcs = async (req, res) => {
    const {
        body
    } = req;

    if (!body.invoiceid){
        return res.status(400).json({
            message:"invoiceid required"
        })
    }else{
        try {
            const InvoiceID = body.invoiceid;
            const params = {
                invoiceid: InvoiceID
            };
            const result = await callWhmcsApi('GetInvoice', params);
            
            const items = result.items.item;
    
            for (const item of items) {
                // const Typeproduct = await GetType(product.type);
                // const NamaGroup = await GetGroup(product.gid);
                
                let namount = parseFloat(item.amount)
                //console.log('desc :', item.description)
                let ndesc = (item.description).split("\n")[0]
                //console.log('split desc :', ndesc)
                let nppn = parseInt(result.taxrate);
                const ParseData = await ParseDesc(ndesc);
                //console.log('Dari controller : ', ParseData);
                if (item.taxed == 1){
                    namount = parseFloat(namount) + parseFloat( namount * (nppn / 100))
                }
                try {
                    await Truang.create({
                        tgltrans: result.datepaid.split(" ")[0],
                        nmtrans: ndesc,
                        jmlkredit: namount,
                        nmbank: "WHMCS",
                        jenistrans: ParseData.jenistrans,
                        nmproduk: ParseData.nmproduk,
                        periodtrans: ParseData.periodtrans,
                        iduser:'WHMCS',
                        typeproduk: ParseData.typeproduk,
                        noinvoice: result.invoiceid,
                        ppn: nppn,
                        idwhmcs: item.id,
                        createdBy: "System"
                    });
                    console.log({
                        message: 'Created',
                        data: {
                            tgltrans: result.datepaid.split(" ")[0],
                            nmtrans: ndesc,
                            jmlkredit: namount,
                            nmbank: "WHMCS",
                            jenistrans: ParseData.jenistrans,
                            nmproduk: ParseData.nmproduk,
                            periodtrans: ParseData.periodtrans,
                            iduser:'WHMCS',
                            typeproduk: ParseData.typeproduk,
                            noinvoice: result.invoiceid,
                            ppn: nppn,
                            idwhmcs: item.id,
                            createdBy: "System"
                        }
                    })
                  
                } catch (error) {
                    if (error.name === 'SequelizeValidationError') {
                        const validationErrors = error.errors.map(err => ({
                            field: err.path,
                            message: err.message
                        }));
                        console.log({
                            "Validation Error": validationErrors
                        })
                        // res.status(400).json({
                        //     "Validation Error": validationErrors
                        // });
                    } else {
                        res.status(500).json('Internal Server Error');
                        console.log(error)
                    }
                }
            }
            return res.status(200).json({
                message: 'OK'
            });
        } catch (error) {
            console.log(error);
            console.log('Error fetching client data:', error.response ? error.response.data : error.message);
        }
    }
    
}

async function ParseDesc(inputs) {
    let datareturn={}

    nmprod = inputs.split(' - ')[0]
    if(nmprod.slice(0, 6) == "Domain"){
        let val1 = inputs.split(" - ")[1]
        jndom = (typeof val1 != 'undefined') ? val1.substring(val1.length - 2) : null
        if(jndom=='id'){
            nmdom = nmprod + " - ID"
        }else{
            nmdom = nmprod + " - TLD"
        }
        datareturn.nmproduk = nmdom
        
        if(nmprod.split(' ')[1] =='Registration'){
            
            datareturn.typeproduk = "New Order"
        }else if(nmprod.split(' ')[1]=='Renewal'){
            datareturn.typeproduk = "Renewal"
        }
        
        datareturn.jenistrans = 'Pendapatan Jasa'
        //datareturn.ppn ='YA'
        let tgl = inputs.replace(/\r?\n/g, "").substring((inputs.replace(/\r?\n/g, "").length - 24)).substring(0, 23);
        let date1 = tgl.split(" - ")[0]
        let date2 = tgl.split(" - ")[1]
        let dateDiff = moment(date2,"DD/MM/YYYY").diff(moment(date1,"DD/MM/YYYY"),'days');
        if(dateDiff < 31 ){
            datareturn.periodtrans = 'Monthly'
        }else if(dateDiff < 93 && dateDiff > 31){
            datareturn.periodtrans = 'Quarterly'
        }else{
            datareturn.periodtrans = 'Annually'
        }
        datareturn.debitkredit = 'KREDIT'
       // this.valprod(inputs.)
    } else{
        datareturn.jenistrans = 'Pendapatan Jasa'
        let dataRefPRODUK = await Product.findOne({
            where: {
                nmproduk:nmprod,
            },
        })
        let prodSelected = (nmprod && dataRefPRODUK) ? dataRefPRODUK : null
        if(prodSelected) {
            datareturn.nmproduk = prodSelected.nmproduk
            datareturn.nmproduk_id = prodSelected.id
           // this.valprod(inputs.)
           
            //datareturn.ppn ='YA'
            let tgl = inputs.replace(/\r?\n/g, "").substring((inputs.replace(/\r?\n/g, "").length - 24)).substring(0, 23);
            let date1 = tgl.split(" - ")[0]
            let date2 = tgl.split(" - ")[1]
            let dateDiff = moment(date2,"DD/MM/YYYY").diff(moment(date1,"DD/MM/YYYY"),'days');
            if(dateDiff <= 31 ){
                datareturn.periodtrans = 'Monthly'
            }else if(dateDiff < 93 && dateDiff > 31){
                datareturn.periodtrans = 'Quarterly'
            }else{
                datareturn.periodtrans = 'Annually'
            }
            datareturn.debitkredit = 'KREDIT'
            datareturn.typeproduk = ""
        }else{
            datareturn.jenistrans = 'Pendapatan Jasa'
            datareturn.nmproduk = "NON PRODUK"
            datareturn.debitkredit = 'KREDIT'
            datareturn.typeproduk = 'Non-Produk'
            datareturn.periodtrans = 'Daily'
            datareturn.ppn ='0'
        }
    }

    console.log('Dari Function : ', datareturn)
    return datareturn;
}
const postcreate = async (req, res) => {
    const {
        body
    } = req;
    const createdBy = req.user.data.username;
    let createData = {
        ...req.body,
        createdBy
    };

    try {
        await Truang.create(createData);

        return res.status(201).json({
            message: 'Created'
        });
    } catch (error) {
        if (error.name === 'SequelizeValidationError') {
            const validationErrors = error.errors.map(err => ({
                field: err.path,
                message: err.message
            }));
            res.status(400).json({
                "Validation Error": validationErrors
            });
        } else {
            res.status(500).json({
                error: 'Internal Server Error',
                message : error.message
            });
        }
    }

}
const getall = async (req, res) => {
    try {
        const Truangs = await Truang.findAll({
            attributes: {
                exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt']
            }
        });
        if (Truangs.length != 0) {
            return res.json(Truangs);
        } else {
            return res.status(404).json({
                message: "Data tidak ditemukan"
            });
        }
    } catch (error) {
        res.status(500).json({
            error: 'Internal Truang Error'
        });
    }
}
const getid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const Truangs = await Truang.findByPk(id, {
            attributes: {
                exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt']
            }
        });
        if (!Truangs)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        return res.json(Truangs);
    } catch (error) {
        res.status(500).json({
            error: 'Internal Truang Error'
        });
    }
}
const putid = async (req, res) => {
    const {
        id
    } = req.params;
    const updatedBy = req.user.data.username;
    let updateData = {
        ...req.body,
        updatedBy
    };
    try {
        const Truangs = await Truang.findByPk(id, {});
        if (!Truangs)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        await Truangs.update(updateData);
        return res.status(201).json({
            message: 'Updated'
        });
    } catch (error) {
        if (error.name === 'SequelizeValidationError') {
            const validationErrors = error.errors.map(err => ({
                field: err.path,
                message: err.message
            }));
            res.status(400).json({
                "Validation Error": validationErrors
            });
        } else {
            res.status(500).json({
                error: 'Internal Truang Error'
            });
        }
    }
}
const delid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const Truangs = await Truang.findByPk(id, {});
        if (!Truangs)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        await Truangs.destroy();
        return res.json({
            message: "Deleted",
        });
    } catch (error) {
        res.status(500).json({
            error: 'Internal Truang Error'
        });
    }
}
module.exports = {
    postwhmcs,
    getall,
    postcreate,
    getid,
    putid,
    delid
}