require('dotenv').config();
const jwt = require("jsonwebtoken");

module.exports = async (req, res, next) => {
    // Get auth token
    const token = req.headers.authorization;
  
    if (!token)
      return res.status(403).json({
        message: "Incorrect credential",
      });
  
    const JWTToken = token.split(" ").pop();
  
    try {
        jwt.verify(JWTToken, process.env.JWT_SECRET, (err, user) => {
            if(err){
                return res.status(403).json({
                    message : "Invalid Token !!!"
                });
            }
            req.user = user;
            // console.log(
            //   req.user.data.username
            // )           
            next();
        })
    } catch (error) {
      console.log(error);
      return res.status(403).json({
        message: "Incorrect credential",
      });
    }
  };