module.exports = function(sequelize, DataTypes) {
    const Jenisdana = sequelize.define("Jenisdana", {
      id: {
        autoIncrement: true,
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true
      },
      namadana: {
        type: DataTypes.STRING(150),
        allowNull: false,
        unique: true,
        validate: {
          notNull: {
            msg: "Tidak Boleh Null/Kosong"
        },
        notEmpty: {
            msg: "Tidak Boleh Null/Kosong"
        }
        }
      },
      createdBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE
      },
      updatedBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE
      }
    }, 
    {
      tableName: 'm_jenisdana',
      timestamps: true,
    });
    return Jenisdana;
  };
  