module.exports = function(sequelize, DataTypes) {
    const Jenistr = sequelize.define("Jenistr", {
      id: {
        autoIncrement: true,
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true
      },
      namatr: {
        type: DataTypes.STRING(150),
        allowNull: false,
        unique: true,
        validate: {
          notNull: {
            msg: "Tidak Boleh Null/Kosong"
        },
        notEmpty: {
            msg: "Tidak Boleh Null/Kosong"
        }
        }
      },
      typetr: {
        type: DataTypes.STRING(10),
        allowNull: false,
        validate: {
          notNull: {
            msg: "Hanya bisa diisi dengan Debit atau Kredit"
        },
        isIn: {
            args: [['Debit', 'Kredit']],
            msg: "Hanya bisa diisi dengan Debit atau Kredit"
          }
        }
      },
      createdBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE
      },
      updatedBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE
      }
    }, 
    {
      tableName: 'm_jenistr',
      timestamps: true,
    });
    return Jenistr;
  };
  