module.exports = function (sequelize, DataTypes) {
    const Karyawanfm = sequelize.define("Karyawanfm", {
        id: {
            autoIncrement: true,
            type: DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true
        },
        nik: {
            type: DataTypes.BIGINT,
            allowNull: true
        },
        nmlengkap: {
            type: DataTypes.STRING(100),
            allowNull: false,
            validate: {
                notNull: {
                    msg: "Tidak Boleh Null/Kosong"
                },
                notEmpty: {
                    msg: "Tidak Boleh Null/Kosong"
                }
            }
        },
        hubungan: {
            type: DataTypes.STRING(30),
            allowNull: true
        },
        nohp: {
            type: DataTypes.STRING(15),
            allowNull: true
        },
        nip: {
            type: DataTypes.STRING(50),
            allowNull: false,
            validate: {
                notNull: {
                    msg: "Tidak Boleh Null/Kosong"
                },
                notEmpty: {
                    msg: "Tidak Boleh Null/Kosong"
                }
            }
        },
        createdBy: {
            type: DataTypes.STRING(255),
            allowNull: true
        },
        createdAt: {
            allowNull: false,
            type: DataTypes.DATE
        },
        updatedBy: {
            type: DataTypes.STRING(255),
            allowNull: true
        },
        updatedAt: {
            allowNull: false,
            type: DataTypes.DATE
        }
    }, {
        tableName: 'm_karyawanfm',
        timestamps: true,
    });
    return Karyawanfm;
};