module.exports = function(sequelize, DataTypes) {
    const Prepinjam = sequelize.define("Prepinjam", {
      id: {
        autoIncrement: true,
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true
      },
      nip: {
        type: DataTypes.STRING(10),
        allowNull: false,
        validate: {
          notNull: {
            msg: "Tidak Boleh Null/Kosong"
        },
          notEmpty: {
            msg: "Tidak Boleh Null/Kosong"
        }
        }
      },
      premi: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        validate: {
          isDecimal: {
            msg: "Format Double, gunakan tanda titik untuk desimal"
        }
        }
      },
      createdBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE
      },
      updatedBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE
      }
    }, 
    {
      tableName: 'd_prepinjam',
      timestamps: true,
    });
    return Prepinjam;
  };
  