module.exports = function(sequelize, DataTypes) {
    const Salary = sequelize.define("Salary", {
      id: {
        autoIncrement: true,
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true
      },
      blnsal: {
        type: DataTypes.STRING(6),
        allowNull: false,
        validate: {
          notNull: {
            msg: "Tidak Boleh Null/Kosong. Gunakan Format YYYYMM"
        },
          notEmpty: {
            msg: "Tidak Boleh Null/Kosong. Gunakan Format YYYYMM"
        },
          isNumeric: {
            msg: "Isian Harus Angka. Gunakan Format YYYYMM"
        },
          len: {
            args:[6,6],
            msg: "Isian Harus 6 Digit Angka. Gunakan Format YYYYMM"
          }
        }
      },
      nip: {
        type: DataTypes.STRING(50),
        allowNull: false,
        validate: {
          notNull: {
            msg: "Tidak Boleh Null/Kosong"
        },
          notEmpty: {
            msg: "Tidak Boleh Null/Kosong"
        }
        }
      },
      current: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0,
        validate: {
          isDecimal: {
            msg: "Format Double, gunakan tanda titik untuk desimal"
        }
        }
      },
      tjabatan: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0,
        validate: {
          isDecimal: {
            msg: "Format Double, gunakan tanda titik untuk desimal"
        }
        }
      },
      tkon: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0,
        validate: {
          isDecimal: {
            msg: "Format Double, gunakan tanda titik untuk desimal"
        }
        }
      },
      ttrans: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0,
        validate: {
          isDecimal: {
            msg: "Format Double, gunakan tanda titik untuk desimal"
        }
        }
      },
      intensif: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0,
        validate: {
          isDecimal: {
            msg: "Format Double, gunakan tanda titik untuk desimal"
        }
        }
      },
      pinjaman: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0,validate: {
          isDecimal: {
            msg: "Format Double, gunakan tanda titik untuk desimal"
        }
        }        
      },
      gajimuka: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0,
        validate: {
          isDecimal: {
            msg: "Format Double, gunakan tanda titik untuk desimal"
        }
        }
      },
      bpjstk: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0,
        validate: {
          isDecimal: {
            msg: "Format Double, gunakan tanda titik untuk desimal"
        }
        }
      },
      bpjskes: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0,
        validate: {
          isDecimal: {
            msg: "Format Double, gunakan tanda titik untuk desimal"
        }
        }
      },
      pph21: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0,
        validate: {
          isDecimal: {
            msg: "Format Double, gunakan tanda titik untuk desimal"
        }
        }
      },
      askes: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0,
        validate: {
          isDecimal: {
            msg: "Format Double, gunakan tanda titik untuk desimal"
        }
        }
      },
      tabungan: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0,
        validate: {
          isDecimal: {
            msg: "Format Double, gunakan tanda titik untuk desimal"
        }
        }
      },
      createdBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE
      },
      updatedBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE
      }
    }, 
    {
      tableName: 'd_salary',
      timestamps: true,
    });
    return Salary;
  };
  