module.exports = function(sequelize, DataTypes) {
    const Salaryinc = sequelize.define("Salaryinc", {
      id: {
        autoIncrement: true,
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true
      },
      thnsal: {
        type: DataTypes.STRING(4),
        allowNull: false,
        validate: {
          notNull: {
            msg: "Tidak Boleh Null/Kosong. Gunakan Format YYYY"
        },
          notEmpty: {
            msg: "Tidak Boleh Null/Kosong. Gunakan Format YYYY"
        },
          isNumeric: {
            msg: "Isian Harus Angka. Gunakan Format YYYY"
        },
          len: {
            args:[4,4],
            msg: "Isian Harus 4 Digit Angka. Gunakan Format YYYY"
          }
        }
      },
      blnsal: {
        type: DataTypes.INTEGER,
        allowNull: false,
        validate: {
          notNull: {
            msg: "Tidak Boleh Null/Kosong"
        },
          notEmpty: {
            msg: "Tidak Boleh Null/Kosong"
        },
          isNumeric: {
            msg: "Isian Harus Angka. Gunakan Angka 0-12"
        },
          len: {
            args:[1,2],
            msg: "Isian Harus Angka. Gunakan Angka 0-12"
          }
        }
      },
      nip: {
        type: DataTypes.STRING(50),
        allowNull: false,
        validate: {
          notNull: {
            msg: "Tidak Boleh Null/Kosong"
        },
          notEmpty: {
            msg: "Tidak Boleh Null/Kosong"
        }
        }
      },
      nilaiinc: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0,
        validate: {
          isDecimal: {
            msg: "Format Double, gunakan tanda titik untuk desimal"
        }
      }
      },
      createdBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE
      },
      updatedBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE
      }
    }, 
    {
      tableName: 'd_salaryinc',
      timestamps: true,
    });
    return Salaryinc;
  };
  