module.exports = function(sequelize, DataTypes) {
    const Trlembur = sequelize.define("Trlembur", {
      id: {
        autoIncrement: true,
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true
      },
      nip: {
        type: DataTypes.STRING(10),
        allowNull: false
      },
      nmlembur: {
        type: DataTypes.STRING(50),
        allowNull: false
      },
      tgllem: {
        type: DataTypes.DATEONLY,
        allowNull: false
      },
      jamawal: {
        type: DataTypes.STRING(5),
        allowNull: false,
        validate: {
            isValidTimeFormat(value) {
              const timeRegex = /^([01]?[0-9]|2[0-4]):[0-5][0-9]$/;
              if (!timeRegex.test(value)) {
                throw new Error('Hanya bisa berisi format time HH:MM');
              }
            }
          }
      },
      jamakhir: {
        type: DataTypes.STRING(5),
        allowNull: false,
        validate: {
            isValidTimeFormat(value) {
              const timeRegex = /^([01]?[0-9]|2[0-4]):[0-5][0-9]$/;
              if (!timeRegex.test(value)) {
                throw new Error('Hanya bisa berisi format time HH:MM');
              }
            }
          }
      },
      totaljam: {
        type: DataTypes.DOUBLE,
        allowNull: false
      },
      nilailem: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        validate: {
            notNull: {
              msg: "Tidak Boleh Null/Kosong"
          },
          notEmpty: {
              msg: "Tidak Boleh Null/Kosong"
          },
          isDecimal: {
              msg: "Format Double, gunakan tanda titik untuk desimal"
          }
          }
      },
      tempat: {
        type: DataTypes.STRING(10),
        allowNull: false,
        validate: {
            notNull: {
              msg: "Hanya bisa diisi dengan Kantor, Rumah atau DC"
          },
          isIn: {
              args: [['Kantor', 'Rumah', 'DC']],
              msg: "Hanya bisa diisi dengan Kantor, Rumah atau DC"
            }
          }
      },
      ketlembur: {
        type: DataTypes.STRING(200),
        allowNull: false
      },
      status: {
        type: DataTypes.STRING(10),
        allowNull: false,
        validate: {
            notNull: {
              msg: "Hanya bisa diisi dengan APPROVE, DECLINE, PENDING atau REVISI"
          },
          isIn: {
              args: [['APPROVE', 'DECLINE', 'PENDING', 'REVISI']],
              msg: "Hanya bisa diisi dengan APPROVE, DECLINE, PENDING atau REVISI"
            }
          }
      },
      note: {
        type: DataTypes.STRING(200),
        allowNull: true
      },
      markbulan: {
        type: DataTypes.STRING(6),
        allowNull: false
      },
      createdBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE
      },
      updatedBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE
      }
    }, 
    {
      tableName: 'tr_lembur',
      timestamps: true,
    });
    return Trlembur;
  };
  