module.exports = function(sequelize, DataTypes) {
    const Truang = sequelize.define("Truang", {
      id: {
        autoIncrement: true,
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true
      },
      tgltrans: {
        type: DataTypes.DATEONLY,
        allowNull: false
      },
      nmtrans: {
        type: DataTypes.STRING(200),
        allowNull: false
      },
      jmldebet: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0
      },
      jmlkredit: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0
      },
      nmbank: {
        type: DataTypes.STRING(20),
        allowNull: true
      },
      jenistrans: {
        type: DataTypes.STRING(100),
        allowNull: false
      },
      nmproduk: {
        type: DataTypes.STRING(50),
        allowNull: false
      },
      periodtrans: {
        type: DataTypes.STRING(20),
        allowNull: false
      },
      iduser: {
        type: DataTypes.STRING(50),
        allowNull: false
      },
      typeproduk: {
        type: DataTypes.STRING(15),
        allowNull: true,
        defaultValue: "-"
      },
      kettrans: {
        type: DataTypes.STRING(50),
        allowNull: true,
        defaultValue: "-"
      },
      noinvoice: {
        type: DataTypes.STRING(50),
        allowNull: false,
        defaultValue: "-"
      },
      img: {
        type: DataTypes.STRING(100),
        allowNull: true,
        defaultValue: "empty.jpg"
      },
      ppn: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: 0
      },
      idwhmcs: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: 0
      },
      createdBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE
      },
      updatedBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE
      }
    }, 
    {
      tableName: 'tr_uang',
      timestamps: true,
    });
    return Truang;
  };
  