const express = require('express');
const PinjamController = require('../controllers/pinjam')
const router = express.Router();
const tokenMiddleware = require('../middlewares/verifytoken');

router.post('/', tokenMiddleware, PinjamController.postcreate);
router.get('/', tokenMiddleware, PinjamController.getall);

router
    .route('/:id')
    .get(tokenMiddleware, PinjamController.getid)
    .put(tokenMiddleware, PinjamController.putid)
    .delete(tokenMiddleware, PinjamController.delid);
module.exports = router;