const express = require('express');
const ProductController = require('../controllers/product')
const router = express.Router();
const tokenMiddleware = require('../middlewares/verifytoken');

router.post('/', tokenMiddleware, ProductController.postcreate);
router.get('/', tokenMiddleware, ProductController.getall);
router.get('/whmcs/', ProductController.getwhmcs);
router
    .route('/:id')
    .get(tokenMiddleware, ProductController.getid)
    .put(tokenMiddleware, ProductController.putid)
    .delete(tokenMiddleware, ProductController.delid);
module.exports = router;